/* eslint-disable prefer-rest-params */
let estaNoTutorial = false;
async function avancarPag() {
    currentFs = $(this).parent();
    nextFs = $(this).parent().next();

    $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

    nextFs.show();
    currentFs.animate({
        opacity: 0
    }, {
        step(now) {
            opacity = 1 - now;

            currentFs.css({
                'display': 'none',
                'position': 'relative'
            });
            nextFs.css({
                'opacity': opacity
            });
        },
        duration: 600
    });
}

$('#tutorial').on('click', function () {
    estaNoTutorial = true;
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    avancarPag();
                    $('#avancar1').trigger('click');
                };
                if ((Element.node.id == 'avancar2')) {
                    $('#avancar2').trigger('click');
                }
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'tourEmpresas') {
                    $('#voltar').trigger('click');
                };
                if (Element.node.id == 'tourGuias') {
                    $('#voltar2').trigger('click');
                }
            }
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDesc',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCpf',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDiaPagto',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#tourEmpresas',
            popover: {
                title: 'Empresas Disponíveis',
                description: 'Aqui estão as empresas do representante.',
                position: 'top'
            }
        },
        {
            element: '#avancar2',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#tourGuias',
            popover: {
                title: 'Dados de Alteração',
                description: 'Aqui estão os guias que este representate pode ter.',
                position: 'top'
            }
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar os dados do Representante.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let contadorInputComissao = 0;
    let contadorTabelaGuia = 0;
    let contadorTabelaVinculo = 0;

    let contaFs = 1;

    $(".next").click(function () {

        contaFs += 1;

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {

            currentFs = $(this).parent().parent().parent().parent();
            nextFs = $(this).parent().parent().parent().parent().next();

            $("#progressbar li").eq($("fieldset.fsPrincipal").index(nextFs)).addClass("active");

            nextFs.show();
            currentFs.animate({
                opacity: 0
            }, {
                step(now) {
                    opacity = 1 - now;

                    currentFs.css({
                        'display': 'none',
                        'position': 'relative'
                    });
                    nextFs.css({
                        'opacity': opacity
                    });
                },
                duration: 600
            });
            $("#tabela-empAcesso").DataTable().columns.adjust().draw(false);
        }

        $("#tabela-empAcesso").DataTable().columns.adjust().draw(false);
        $("#tabelaSetores").DataTable().columns.adjust().draw(false);
    });

    $(".previous").click(function () {

        contaFs -= 1;

        currentFs = $(this).parent().parent().parent().parent();
        previousFs = $(this).parent().parent().parent().parent().prev();
        $("#progressbar li").eq($("fieldset.fsPrincipal").index(currentFs)).removeClass("active");
        previousFs.show();
        currentFs.animate({
            opacity: 0
        }, {
            step(now) {
                opacity = 1 - now;
                currentFs.css({
                    'display': 'none',
                    'position': 'relative'
                });
                previousFs.css({
                    'opacity': opacity
                });
            },
            duration: 600
        });
        $("#tabela-empAcesso").DataTable().columns.adjust().draw(false);
    });

    $('#tabelaGuias').DataTable({
        paging: true,
        pageLength: 6,
        filter: false,
        info: false,
        order: false,
        autoWidth: true,
        destroy: true,
    });

    $('#tabelaVinculos').DataTable({
        paging: true,
        filter: false,
        info: false,
        order: false,
        autoWidth: true,
        destroy: true,
    });

    $('#txtComFat').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtComRec').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtDiaPagto').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 0
    });

    let SPMaskBehavior = function (val) {
        return val.length === 15 ? '(00) 00000-0000' : '(00) 0000-00009';
    };
    let spOptions = {
        onKeyPress(val, e, field, options) {
            field.mask(SPMaskBehavior.apply({}, arguments), options);
        }
    };

    $('#txtTelefone').mask(SPMaskBehavior, spOptions);

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('REPRESENTANTE', getCookie('usuario'), representante);
        window.location.href = `${BASE_URI}/representante`;
    });

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtCodigo: {
                    required: true,
                },
                txtDesc: {
                    required: true,
                },
                txtCpf: {
                    required: true,
                },
                txtDiaPagto: {
                    required: true,
                }
            },
            messages: {
                txtCodigo: {
                    required: "Informe um código válido."
                },
                txtDesc: {
                    required: "Informe um nome válido."
                },
                txtCpf: {
                    required: "Informe um CPF/CNPJ válido."
                },
                txtDiaPagto: {
                    required: "Informe um dia de pagamento válido."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#tabela-empAcesso').DataTable({
        paging: false,
        autoWidth: false,
        filter: false,
        info: false,
        ordering: false,
        destroy: true,
        scrollY: "300px",
        "columnDefs": [{
            "targets": [2],
            "visible": false
        }]
    });

    let dataSet = await RetornaEmpresas();
    await preencheSetores();
    $("#tabela-empAcesso").DataTable().columns.adjust().draw(false);

    const qtdeRegistros = $('#tabelaSetores').DataTable().rows().data()

    if (qtdeRegistros > 0) {
        $("#tabelaSetores").DataTable().columns.adjust().draw(false);
    }


    function botaoSelecionarGrid() {
        return `<div class="form-check icheck-primary">
                <input type="checkbox" class="align-self-center checkEmpresa" value""> <label for=""></label>
                </div>`;
    };

    $('#tabela-empAcesso').DataTable().rows().remove().draw(false);
    for (let i = 0; i < dataSet.length; i++) {
        const empresa = dataSet[i];
        $('#tabela-empAcesso').DataTable().row.add([botaoSelecionarGrid(), `${empresa.EMP_PAT} - ${empresa.EMP_NOME}`, `${empresa.EMP_ID}`]).draw(false);
    }

    $('#tabela-empAcesso').on('click', 'td', function () {
        selecionarLinhaTabela('#tabela-empAcesso', 'checkEmpresa', this);
    });

    async function filtrarEmpresaUsuario() {
        const dadosSelect = {
            orderBy: ['EMPRESA.EMP_PAT'],
            tabela: `ACESSO_EMPRESA`,
            leftJoin: [{ "tabela": "EMPRESA", "condicao": "REPLACE(EMPRESA.EMP_PAT,'_','') = ACESSO_EMPRESA.EMPRESA" }],
            camposSelect: ['EMPRESA.EMP_ID', 'ACESSO_EMPRESA.EMPRESA', 'EMPRESA.EMP_NOME', 'EMPRESA.EMP_FANTASIA'],
            where: [`ACESSO_EMPRESA.USUARIO = '${getCookie('cod_usuario')}'`],
        };
        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
        if (!retornoSelect) {
            return;
        }
        if (retornoSelect && retornoSelect.length > 0) {
            return retornoSelect;
        }
        return '';
    }


    async function RetornaEmpresas() {
        const url = `/sisplan/funcoes/v1/pesquisa?`;
        const pesquisa = { tabela: "empresa", camposSelect: ["emp_id", "emp_pat", "emp_nome"], where: [] };

        const deveFiltrarEmpresaUsuario = await filtrarEmpresaUsuario();
        if ((getCookie('cod_usuario') != '0000') && (deveFiltrarEmpresaUsuario != '')) {
            const filtroEmpresas = await formataListas(deveFiltrarEmpresaUsuario.map(emp => emp.EMPRESA).toString());
            pesquisa.where.push(`REPLACE(EMP_PAT, '_','') IN (${filtroEmpresas})`);
        }
        const params = `JSON=${JSON.stringify(pesquisa)}`;


        try {
            const response = await requisicao('GET', url, params, null);

            if (!response) {
                return '';
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return '';
            }

            const arrDados = jsonStr.RESULT[0];
            return arrDados;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar as empresas.');
            return '';
        }
    }

    $('#txtTabPreco').pesquisa_variosServerside(1, '{ "tabela":"REGIAO", "camposSelect":["REGIAO", "DESCRICAO"],  "where": null}', "REGIAO", "DESCRICAO");
    $("#btnTabPreco").pesquisa_serversideSel("#txtTabPreco", `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}`, "Pesquisa de Tabela de Preço");

    $('#txtCep').autocompleta(1, `JSON={ "tabela":"cadcep", "camposSelect":[ "cep chave", "codmun descricao"], "where": null}`);
    $('#txtCoordenador').autocompleta(1, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtTipoEntidade').autocompleta(1, `JSON={ "tabela":"sitcli", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtGrupoCliente').autocompleta(1, `JSON={ "tabela":"grupo_cli", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtGuia').autocompleta(1, `JSON={ "tabela": "represen", "camposSelect": ["codrep chave", "nome descricao"], "where": ["REPRESEN.ATIVO = 'S'", "REPRESEN.GRUPO_REP = 'U'"]}`);
    // $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO chave", "descricao descricao"], "where": null}`);
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO chave", "descricao descricao"], "where": null}`);

    // $('#btnTabPreco').pesquisa('#txtTabelaPreco', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}`, 'Pesquisa de Tabela de Preço', 'REGIAO');
    $('#btnDeposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Depósito', 'DEPOSITO');
    $('#btnCep').pesquisa('#txtCep', 'CEP', 'CODMUN', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadcep", "camposSelect":[ "cep", "codmun"]}`, 'Pesquisa CEP', 'cadcep');
    $('#btnCoordenador').pesquisa_serverside(['#txtCoordenador'], ['CODCLI', 'NOME'], ['CODCLI', 'NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Coordenador');
    $('#btnTipoEntidade').pesquisa('#txtTipoEntidade', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"sitcli", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Tipo Entidade', 'sitcli');
    $('#btnGrupoCliente').pesquisa('#txtGrupoCliente', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"grupo_cli", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Grupo Cliente', 'grupo_cli');
    $('#btn-Guia').pesquisa('#txtGuia', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "represen", "camposSelect": ["codrep", "nome"], "where": ["ativo = 'S'", "grupo_rep = 'U'"]}`, 'Pesquisa Guia', 'Represen');

    $('#btnACep').on('click', function () {
        $('#txtCep').val('');
    });
    $('#btnACoordenador').on('click', function () {
        $('#txtCoordenador').val('');
    });
    $('#btnATipoEntidade').on('click', function () {
        $('#txtTipoEntidade').val('');
    });
    $('#btnAGrupoCliente').on('click', function () {
        $('#txtGrupoCliente').val('');
    });
    $('#btnATabelaPreco').on('click', function () {
        $('#txtTabelaPreco').val('');
    });
    $('#btnADeposito').on('click', function () {
        $('#txtDeposito').val('');
    });

    $('#btnATabPreco').on('click', function () {
        $('#txtTabPreco').empty().trigger('change')
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let representante = parametros[parametros.length - 1];

    $('#txtCodigo').prop('disabled', true);

    async function buscaEmpValor(valor, tabela) {
        const url = "/Sisplan/Funcoes/v1/pesquisa?";
        const response = await requisicao(
            "GET",
            url,
            `JSON={ "tabela":"EMP_VALOR", "camposSelect":["EMP_ID"], "where": ["TABELA = '${tabela}'", "VALOR = '${valor}'"]}`
        );

        if (!response) {
            return [];
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return [];
        }
        return jsonStr.RESULT[0];
    }

    async function executaSelectEmpresa(codigo, tabela) {
        try {
            const empValor = await buscaEmpValor(codigo, tabela);
            const url = '/Sisplan/Funcoes/v1/pesquisa?';

            if (empValor.length > 0) {
                return empValor;
            }
            const response = await requisicao('GET', url, `JSON={ "tabela":"REPRESEN", "camposSelect":["EMP_LOJA", "CODREP"], "where": ["CODREP = '${codigo}'"]}`);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
            }

            const dadosFormatados = [];
            if (jsonStr.RESULT[0].length > 0) {
                let arrayEmp = jsonStr.RESULT[0][0].EMP_LOJA.split(',');
                for (let i = 0; i < arrayEmp.length; i++) {
                    const dados = {};
                    const dadosArray = arrayEmp[i];
                    dados.EMP_ID = dadosArray.substr(1);
                    dadosFormatados.push(dados);
                }
                return dadosFormatados;
            }

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar as empresas.`);
        }
    }

    if (representante != '' && representante != 'create') {

        $('#account').css('cursor', 'pointer');
        $('#payment').css('cursor', 'pointer');
        $('#personal').css('cursor', 'pointer');

        carregarFotos(representante)

        if (await liberarRegistro('REPRESENTANTE', representante) == false) {
            window.location.href = '../representante';
        } else {

            try {
                $.LoadingOverlay("show");

                try {
                    let resposta = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"represen", 
                        "camposSelect":[
                            "represen.ativo", 
                            "represen.comissao", 
                            "represen.comissao2", 
                            "represen.dia_comissao", 
                            "represen.emp_loja", 
                            "represen.grupo_rep", 
                            "represen.cep", 
                            "represen.codrep", 
                            "represen.nome", 
                            "represen.cnpj", 
                            "represen.inscricao", 
                            "represen.bairro", 
                            "represen.endereco", 
                            "represen.telefone", 
                            "represen.email", 
                            "represen.SETORES",
                            "represen.COORDENADOR",
                            "represen.REGIAO",
                            "represen.DEPOSITO",
                            "represen.OBS",
                            "entidade.NOME COORDENADOR_NOME",
                            "represen.GRUPO",
                            "sitcli.DESCRICAO GRUPO_DESC",
                            "represen.GRUPO_CLI",
                            "grupo_cli.DESCRICAO GRUPO_CLI_DESC",
                            "represen.cod_importado",
                            "represen.recon_facial"
                        ], 
                        "LeftJoin": [
                            {"tabela": "grupo_cli", "condicao": "grupo_cli.codigo = represen.grupo_cli"},
                            {"tabela": "sitcli", "condicao": "sitcli.codigo = represen.grupo"},
                            {"tabela": "entidade", "condicao": "entidade.codcli = represen.coordenador"}
                        ],
                        "where": ["represen.codrep = '${representante}'"]
                    }`,
                        null
                    );

                    let jsonRepresen = await resposta.json();
                    if (jsonRepresen.RESULT[0].length > 0) {

                        const codigo = jsonRepresen.RESULT[0][0].CODREP;
                        const tabela = 'REPRESEN';

                        const empValor = await executaSelectEmpresa(codigo, tabela);

                        if (empValor != '') {
                            for (let i = 0; i < empValor.length; i++) {
                                for (let x = 0; x < $('#tabela-empAcesso').DataTable().rows().data().length; x++) {
                                    let dados = $('#tabela-empAcesso').DataTable().rows().data()[x];
                                    let empresa = dados[2];
                                    if (empresa == empValor[i].EMP_ID) {
                                        $($('.checkEmpresa')[x]).prop('checked', true);
                                        $($("table#tabela-empAcesso tr")[x + 1]).addClass("selected");
                                    }
                                }
                            }
                        }



                        let setores = jsonRepresen.RESULT[0][0].SETORES.replaceAll("'", '').split(',');
                        let dadosSetores = $('#tabelaSetores').DataTable().rows().data();

                        if (dadosSetores.length > 0) {

                            for (let j = 0; j < setores.length; j++) {
                                for (let i = 0; i < dadosSetores.length; i++) {
                                    if (setores[j] == dadosSetores[i].CODIGO) {
                                        $(`#checkSetor${i}`).prop('checked', true);
                                        break;
                                    }
                                }
                            }
                        }

                        $('#txtCodigo').val(jsonRepresen.RESULT[0][0].CODREP);
                        $('#txtDesc').val(jsonRepresen.RESULT[0][0].NOME);
                        $('#txtCpf').val(jsonRepresen.RESULT[0][0].CNPJ);
                        $('#txtIe').val(jsonRepresen.RESULT[0][0].INSCRICAO);
                        $('#txtBairro').val(jsonRepresen.RESULT[0][0].BAIRRO);
                        $('#txtEndereco').val(jsonRepresen.RESULT[0][0].ENDERECO);
                        $('#txtTelefone').val(jsonRepresen.RESULT[0][0].TELEFONE);
                        $('#txtEmail').val(jsonRepresen.RESULT[0][0].EMAIL);
                        $('#txtComFat').val(jsonRepresen.RESULT[0][0].COMISSAO);
                        $('#txtComRec').val(jsonRepresen.RESULT[0][0].COMISSAO2);
                        $('#txtDiaPagto').val(jsonRepresen.RESULT[0][0].DIA_COMISSAO);
                        $('#txtObservacao').val(jsonRepresen.RESULT[0][0].OBS);
                        $('#txtCodImportado').val(jsonRepresen.RESULT[0][0].COD_IMPORTADO);
                        $('#checkReconhecimentoFacial').prop('checked', jsonRepresen?.RESULT?.[0]?.[0]?.RECON_FACIAL === 1)

                        insereValor('#txtCoordenador', jsonRepresen.RESULT[0][0].COORDENADOR, jsonRepresen.RESULT[0][0].COORDENADOR_NOME);
                        insereValor('#txtTipoEntidade', jsonRepresen.RESULT[0][0].GRUPO, jsonRepresen.RESULT[0][0].GRUPO_DESC);
                        insereValor('#txtGrupoCliente', jsonRepresen.RESULT[0][0].GRUPO_CLI, jsonRepresen.RESULT[0][0].GRUPO_CLI_DESC);

                        if (jsonRepresen.RESULT[0][0].GRUPO_REP == 'R') {
                            $('#radioRepresentante').prop('checked', true);
                        }
                        if (jsonRepresen.RESULT[0][0].GRUPO_REP == 'V') {
                            $('#radioVendedor').prop('checked', true);
                        }
                        if (jsonRepresen.RESULT[0][0].GRUPO_REP == 'G') {
                            $('#radioGerente').prop('checked', true);
                        }
                        if (jsonRepresen.RESULT[0][0].GRUPO_REP == 'U') {
                            $('#radioGuia').prop('checked', true);
                        }
                        if (jsonRepresen.RESULT[0][0].ATIVO == 'S') {
                            $('#checkAtivo').prop('checked', true);
                        } else {
                            $('#checkAtivo').prop('checked', false);
                        }

                        await BuscaDadosGuia($('#txtCodigo').val());

                        await BuscaDadosSupervisor($('#txtCodigo').val());

                        try {
                            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                `JSON={ "tabela":"cadcep", 
                            "camposSelect":["codmun"], 
                            "where": ["cep = '${jsonRepresen.RESULT[0][0].CEP}'"]}`, null);

                            let jsonCep = await response.json();

                            insereValor('#txtCep', jsonRepresen.RESULT[0][0].CEP, jsonCep.RESULT[0][0].CODMUN);

                        } catch (error) {
                            console.error(error);
                        }

                        try {
                            let responseRegiao = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                `JSON={ "tabela":"REGIAO", 
                            "camposSelect":["REGIAO", "DESCRICAO"], 
                            "where": ["REGIAO = '${jsonRepresen.RESULT[0][0].REGIAO}'"]}`, null);

                            let responseRepRegiao = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                `JSON={ "tabela":"REP_REGIAO", 
                            "camposSelect":["REP_REGIAO.CODREP, REP_REGIAO.REGIAO, REGIAO.DESCRICAO"],
                            "leftJoin": [
                                {"tabela": "REPRESEN", "condicao": "REPRESEN.CODREP  = REP_REGIAO.CODREP"},
                                {"tabela": "REGIAO", "condicao": "REGIAO.REGIAO  = REP_REGIAO.REGIAO"}
                            ], 
                            "where": ["1=1", "REP_REGIAO.CODREP = '${jsonRepresen.RESULT[0][0].CODREP}'"]}`, null);

                            let jsonTabPreco = await responseRegiao.json();
                            let jsonRepRegiao = await responseRepRegiao.json();

                            // insereValor('#txtTabPreco', jsonRepresen.RESULT[0][0].REGIAO, jsonTabPreco.RESULT[0][0].DESCRICAO);


                            if (jsonRepRegiao.RESULT[0][0].REGIAO !== '') {
                                // $.LoadingOverlay('show');
                                if (jsonRepRegiao.RESULT[0].length > 0) {
                                    await insereValorPesquisaVarios('txtTabPreco', 'REGIAO', 'DESCRICAO', jsonRepRegiao.RESULT[0])
                                } else {
                                    await insereValorPesquisaVarios('txtTabPreco', 'REGIAO', 'DESCRICAO', jsonTabPreco.RESULT[0])
                                }
                            } else {
                                await insereValorPesquisaVarios('txtTabPreco', 'REGIAO', 'DESCRICAO', jsonTabPreco.RESULT[0])
                            }
                        } catch (error) {
                            console.error(error);
                        }

                        try {
                            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                `JSON={ "tabela":"DEPOSITO", 
                            "camposSelect":["CODIGO, DESCRICAO"], 
                            "where": ["CODIGO = '${jsonRepresen.RESULT[0][0].DEPOSITO}'"]}`, null);

                            let jsonDeposito = await response.json();

                            if (jsonDeposito.RESULT[0].length > 0) {
                                insereValor('#txtDeposito', jsonRepresen.RESULT[0][0].DEPOSITO, jsonDeposito.RESULT[0][0].DESCRICAO);
                            };

                        } catch (error) {
                            console.error(error);
                        }

                    } else {

                        try {
                            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                `JSON={ "tabela":"entidade", 
                        "camposSelect":["codcli", "nome", "cnpj", "inscricao", "cep", "bairro", "endereco", "telefone", "email"], 
                        "where": ["codcli = '${representante}'"]}`, null);

                            if (!response) {
                                return;
                            }
                            let jsonStr = await response.json();
                            if (response.status != 200) {
                                msgErro(jsonStr.RESULT[0].mensagem);
                                return;
                            }

                            $('#txtCodigo').val(jsonStr.RESULT[0][0].CODCLI);
                            $('#txtDesc').val(jsonStr.RESULT[0][0].NOME);
                            $('#txtCpf').val(jsonStr.RESULT[0][0].CNPJ);
                            $('#txtIe').val(jsonStr.RESULT[0][0].INSCRICAO);
                            $('#txtBairro').val(jsonStr.RESULT[0][0].BAIRRO);
                            $('#txtEndereco').val(jsonStr.RESULT[0][0].ENDERECO);
                            $('#txtTelefone').val(jsonStr.RESULT[0][0].TELEFONE);
                            $('#txtEmail').val(jsonStr.RESULT[0][0].EMAIL);

                            try {
                                response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                    `JSON={ "tabela":"cadcep", 
                            "camposSelect":["codmun"], 
                            "where": ["cep = '${jsonStr.RESULT[0][0].CEP}'"]}`, null);

                                let jsonCep = await response.json();

                                insereValor('#txtCep', jsonStr.RESULT[0][0].CEP, jsonCep.RESULT[0][0].CODMUN);

                            } catch (error) {
                                console.error(error);
                            }

                        } catch (error) {
                            console.error(error);
                            msgErro(`Não foi possível buscar os dados do representante: ${error}`);
                        }
                    }
                } catch (error) {
                    console.error(error);
                }

            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $('#account').on('click', function () {
        if (representante != 'create') {
            if (contaFs == 2) {
                $('#voltar').trigger('click');
            }
            if (contaFs == 3) {
                $('#voltar2').trigger('click');
                $('#voltar').trigger('click');
            }
        }
    });

    $('#payment').on('click', function () {
        if (representante != 'create') {
            if (contaFs == 1) {
                $('#avancar1').trigger('click');
            }
            if (contaFs == 3) {
                $('#voltar2').trigger('click');
            }
        }
    });

    $('#personal').on('click', function () {
        if (representante != 'create') {
            if (contaFs == 1) {
                $('#avancar1').trigger('click');
                $('#avancar2').trigger('click');
            }
            if (contaFs == 2) {
                $('#avancar2').trigger('click');
            }
        }
    });

    $('#avancar2').on('click', function () {
        if (!estaNoTutorial) {
            $('#txtSupervisor').on('blur', async function () {
                await AlimentaGridSupervisor();
            });
        } else {
            estaNoTutorial = false
        }
    })

    $('#txtDiaPagto').change(async function () {
        if ($('#txtDiaPagto').val() > 31) {
            $('#txtDiaPagto').val(31);
        }
        if ($('#txtDiaPagto').val() < 1) {
            $('#txtDiaPagto').val(1);
        }
    });

    $('#txtGuia').on('blur', async function () {
        await AlimentaGridGuia();
    });

    async function AlimentaGridGuia() {
        const CodRep = pegaChave('#txtGuia');
        const NomeRepresentante = pegaDescricao('#txtGuia');
        const linhas = $('#tabelaGuias').DataTable().rows().count();
        let adicionaRegistro = true;
        if (CodRep != '') {
            if (linhas <= 0) {
                $('#tabelaGuias').DataTable().row.add([retornaBotaoOpcoes(CodRep, 'Guia'), NomeRepresentante]).draw(false);
            } else {
                const listaBtns = $('.btnGuia');
                for (let i = 0; i < linhas; i++) {
                    if (listaBtns[i].value == CodRep) {
                        adicionaRegistro = false;
                    }
                }
                if (adicionaRegistro) {
                    $('#tabelaGuias').DataTable().row.add([retornaBotaoOpcoes(CodRep, 'Guia'), NomeRepresentante]).draw(false);
                } else {
                    msgAlerta('Código de representante já adicionado no grid! Impossivel adicionar novamente.');
                }
            }
            $('#txtGuia').val('');
        }
    }

    async function AlimentaGridSupervisor() {
        const CodRep = pegaChave('#txtSupervisor');
        const NomeRepresentante = pegaDescricao('#txtSupervisor');
        const linhas = $('#tabelaVinculos').DataTable().rows().count();
        let adicionaRegistro = true;
        if (CodRep != '') {
            if (linhas <= 0) {
                $('#tabelaVinculos').DataTable().row.add([retornaBotaoOpcoes(CodRep, 'Vinculo'), NomeRepresentante, retornaInputComissao(), retornaDropDownTipo()]).draw(false);
                mascaraValor();
            } else {
                const listaBtns = $('.btnVinculo');
                for (let i = 0; i < linhas; i++) {
                    if (listaBtns[i].value == CodRep) {
                        adicionaRegistro = false;
                    }
                }
                if (adicionaRegistro) {
                    $('#tabelaVinculos').DataTable().row.add([retornaBotaoOpcoes(CodRep, 'Vinculo'), NomeRepresentante, retornaInputComissao(), retornaDropDownTipo()]).draw(false);
                    mascaraValor();
                } else {
                    msgAlerta('Código de representante já adicionado no grid! Impossivel adicionar novamente.');
                }
            }
            $('#txtSupervisor').val('');
        }
    };

    function retornaInputComissao(value = '') {
        const div = '<div> ' +
            `    <input id="txtComissao" class="input-default focus form-control text-right inputComissao maskDecimais" value="${value}" style="width: 20%; float: right" type="text"></input> ` +
            '   </div>';

        contadorInputComissao++;

        return div
    }

    function retornaDropDownTipo(value = '') {
        const div = '<div> ' +
            `          <select id="selectTipo" class="input-default custom-select dropDownTipo"> ` +
            `              <option value="REC" ${value === 'REC' ? 'selected' : ''}>REC</option> ` +
            `              <option value="FAT" ${value === 'FAT' ? 'selected' : ''}>FAT</option> ` +
            '          </select> ' +
            '        </div>';
        return div
    }


    function montaJsonGuias(CodRep, Guia) {
        const objeto = {
            CodRep,
            Guia
        };
        return objeto;
    }

    function montaJsonSupervisores(codrep_pai, codrep_filho, comissao, tipoComissao, emp_id) {
        const objeto = {
            codrep_pai,
            codrep_filho,
            comissao,
            tipoComissao,
            emp_id
        };
        return objeto;
    };


    $("#gravar").click(
        async function () {

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    representante = {};

                    representante.CODREP = $('#txtCodigo').val();
                    representante.NOME = $('#txtDesc').val();
                    representante.CNPJ = $('#txtCpf').val();
                    representante.INSCRICAO = $('#txtIe').val();
                    representante.CEP = pegaChave('#txtCep', representante.CEP);
                    representante.BAIRRO = $('#txtBairro').val();
                    representante.ENDERECO = $('#txtEndereco').val();
                    representante.COMISSAO = $('#txtComFat').val();
                    representante.COMISSAO2 = $('#txtComRec').val();
                    representante.DIA_COMISSAO = $('#txtDiaPagto').val();
                    representante.EMAIL = $('#txtEmail').val();
                    representante.TELEFONE = $('#txtTelefone').val();
                    representante.COORDENADOR = pegaChave('#txtCoordenador');
                    representante.GRUPO = pegaChave('#txtTipoEntidade');
                    representante.GRUPO_CLI = pegaChave('#txtGrupoCliente');
                    representante.DEPOSITO = pegaChave('#txtDeposito');
                    representante.OBS = $('#txtObservacao').val();
                    representante.REGIAO = $('#txtTabPreco').val()[0];
                    if ($('#txtTabPreco').val().length > 1) {
                        representante.Rep_Regiao = $('#txtTabPreco').val().map((regiao) => {
                            return {
                                Codrep: $('#txtCodigo').val(),
                                Regiao: regiao,
                                Tipo: 'T'
                            }
                        })
                    }

                    if ($('#txtCpf').val().length < 14) {
                        representante.TIPO = '1';
                    } else {
                        representante.TIPO = '2';
                    }

                    if ($('#radioRepresentante').prop('checked')) {
                        representante.GRUPO_REP = 'R';
                    }
                    if ($('#radioVendedor').prop('checked')) {
                        representante.GRUPO_REP = 'V';
                    }
                    if ($('#radioGerente').prop('checked')) {
                        representante.GRUPO_REP = 'G';
                    }
                    if ($('#radioGuia').prop('checked')) {
                        representante.GRUPO_REP = 'U';
                    }

                    if ($('#checkAtivo').prop('checked')) {
                        representante.ATIVO = 'S';
                    } else {
                        representante.ATIVO = 'N';
                    }

                    let arrayEmpresas = [];
                    for (let i = 0; i < $('#tabela-empAcesso').DataTable().rows('.selected').data().length; i++) {
                        let dados = $('#tabela-empAcesso').DataTable().rows('.selected').data()[i];
                        const empresa = dados[2];
                        arrayEmpresas.push(empresa);
                    }

                    representante.EMP_LOJA = arrayEmpresas;
                    representante.EMP_ID_REP = getCookie('g_emp_id_empresa_logada');

                    const data = $("#tabelaSetores").DataTable().data().toArray();
                    let setores = '';

                    for (let i = 0; i < data.length; i++) {
                        if ($(`#checkSetor${i}`)[0].checked == true) {
                            setores += "'" + data[i].CODIGO + "'" + ",";
                        }
                    }
                    representante.SETORES = setores.substring(0, setores.length - 1);

                    const btnGuia = $('.btnGuia');

                    const btnSupervisor = $('.btnVinculo');

                    const inputComissao = $('.inputComissao');

                    const dropDownTipo = $('.dropDownTipo');

                    const arrGuias = $('#tabelaGuias').DataTable().rows().data().toArray().map((guia, index) => montaJsonGuias(representante.CODREP, btnGuia[index].value));

                    let arrSupervisores = $('#tabelaVinculos').DataTable().rows().data().toArray().map((supervisor, index) => {
                        return montaJsonSupervisores(representante.CODREP, btnSupervisor[index].value, inputComissao[index].value, dropDownTipo[index].value, getCookie('g_emp_id_empresa_logada'));
                    });

                    arrSupervisores = arrSupervisores.filter((supervisor) => supervisor !== null);

                    representante.GUIAS = arrGuias;
                    representante.SUPERVISORES = arrSupervisores
                    representante.fotosEmBase64 = Representante.fotos ?? []
                    representante.reconhecimentoFacial = $('#checkReconhecimentoFacial').prop('checked')

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/representante?', ``, JSON.stringify(representante), 60000);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }

                    $.LoadingOverlay("hide");
                    toastr.success(
                        'Cadastro efetuado com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/representante`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                } catch (error) {
                    $.LoadingOverlay("hide");
                    msgErro(`Não foi possível gravar os dados do representante: ${error}`);
                }
            }
        });

    async function BuscaDadosGuia(CodRep) {
        const dadosSelect = {
            Tabela: 'rep_guia',
            CamposSelect: ["rep_guia.codrep, rep_guia.guia, represen.nome"],
            LeftJoin: [{ "tabela": "represen", "condicao": "rep_guia.guia = represen.codrep" }],
            Where: [`rep_guia.codrep = '${CodRep}'`],
        };

        const response = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(dadosSelect)));

        if (!response) {
            return;
        }
        let jsonStr = response;

        jsonStr.map(element => {
            $('#tabelaGuias').DataTable().row.add([
                retornaBotaoOpcoes(element.GUIA, 'Guia'),
                element.NOME]).draw(false);
            return 'ok';
        });
    }

    function mascaraValor() {
        $('.maskDecimais').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });
    }

    async function BuscaDadosSupervisor(codrep_p) {
        const dadosSelect = {
            Tabela: 'COM_REP_VEN',
            CamposSelect: ["COM_REP_VEN.CODREP_PAI, REPRESEN.NOME, COM_REP_VEN.CODREP_FILHO, COM_REP_VEN.COMISSAO, COM_REP_VEN.TIPO_COMISSAO"],
            LeftJoin: [{ "tabela": "REPRESEN", "condicao": "COM_REP_VEN.CODREP_FILHO = REPRESEN.CODREP" }],
            Where: [`COM_REP_VEN.CODREP_PAI = '${codrep_p}' AND COM_REP_VEN.EMP_ID = '${getCookie('g_emp_id_empresa_logada')}'`],
        };

        const response = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(dadosSelect)));

        if (!response) {
            return;
        }
        let jsonStr = response;

        jsonStr.map(supervisor => {
            $('#tabelaVinculos').DataTable().row.add([
                retornaBotaoOpcoes(supervisor.CODREP_FILHO, 'Vinculo'),
                supervisor.NOME,
                retornaInputComissao(supervisor.COMISSAO),
                retornaDropDownTipo(supervisor.TIPO_COMISSAO)
            ]).draw(false);
            return 'ok';
        });

        mascaraValor();
    };

    $('#btn-Supervisor').pesquisa('#txtSupervisor', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "represen", "camposSelect": ["codrep", "nome"], "where": ["ativo = 'S'", "codrep <> '${representante}'"]}`, 'Pesquisa Supervisor', 'Represen');
    $('#txtSupervisor').autocompleta(1, `JSON={ "tabela": "represen", "camposSelect": ["codrep chave", "nome descricao"], "where": ["REPRESEN.ATIVO = 'S'", "REPRESEN.CODREP <> '${representante}'"]}`);

    async function preencheSetores() {
        try {
            let response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null, "orderBy": ["CODIGO"]}', null);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();

            if (jsonStr.RESULT[0].length == 0) {
                return;
            }

            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            const listaFormatada = [{}];

            jsonStr.RESULT[0].map((item, i) => {
                listaFormatada[i] = {
                    SEL: item.SEL = `
            <div class='icheck-primary'><input type="checkbox" class="align-self-center checkSetor icheck-primary" value""="" id="checkSetor${i}"><label for="checkSetor${i}"></label></div>`,
                    CODIGO: jsonStr.RESULT[0][i].CODIGO,
                    SETORES: jsonStr.RESULT[0][i].CODIGO + ' - ' + jsonStr.RESULT[0][i].DESCRICAO,
                };
            });

            const dataSetCols = [];
            const keys = Object.keys(listaFormatada[0]);
            for (let k in keys) {
                dataSetCols.push({
                    data: keys[k],
                });
            }

            $("#tabelaSetores").DataTable({
                bPaginate: false,
                destroy: true,
                search: false,
                filter: false,
                lengthChange: false,
                serverside: false,
                order: false,
                autoWidth: true,
                data: listaFormatada,
                columns: dataSetCols,
                columnDefs: [
                    {
                        targets: 1,
                        visible: false,
                    },
                ],
            });

        } catch (error) {
            msgErro('Não foi possível buscar os setores.');
            return;
        }
    };

    // $('#tabelaGuias').on('click', '.btnVerificaOpcoes', function () {
    //     $('#tabelaGuias').DataTable().data().rows($('#tabelaGuias').DataTable().row($($(this).get(0)).closest('tr')).index()).remove().draw(false)
    // });

    $('#tabelaGuias').on('click', '#btn-excluirOpcoes', function () {
        $('#tabelaGuias').DataTable().data().rows($('#tabelaGuias').DataTable().row($($(this).get(0)).closest('tr')).index()).remove().draw(false);
    });

    $('#tabelaVinculos').on('click', '#btn-excluirOpcoes', function () {
        $('#tabelaVinculos').DataTable().data().rows($('#tabelaVinculos').DataTable().row($($(this).get(0)).closest('tr')).index()).remove().draw(false);
    });

    function retornaBotaoOpcoes(data, tabela) {
        var retorno = '<div style="text-align:start;"> ' +
            `    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes btn${tabela}" id="btnBotaoOpcoes" value="${data}" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ` +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            `    <button class="dropdown-item" style="width: 100%" type="button" value="${data}" title="Excluir" id="btn-excluirOpcoes">Excluir</button>  ` +
            '</div>';

        return retorno;
    };

    $('#btnFotos').on('click', function () {
        carregarModalFotos()
    })

    function carregarFotos(codigo) {
        buscarFotosRepresentante(codigo)
            .then((resultado) => {
                Representante.fotos = resultado
            }).catch((error) => {
                console.error(error)
            })
    }

    function carregarModalFotos() {
        const fotos = Representante.fotos?.map((it) => ({
            base64: it,
            opcoes: `Opções`,
        })) ?? []
        if (fotos.length === 0) {
            $('#imgRepresentante').attr('src', `${BASE_URI}/dist/img/prod-1.png`)
        }
        criarTabelaFotos(fotos)
        $('#modalFotos').modal('show')
    }

    function retornarBotaoOpcoes(data) {
        const retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>  ' +
            '</div>'
        return retorno
    }

    function criarTabelaFotos(data) {
        if ($.fn.DataTable.isDataTable('#tabelaFotos')) {
            $('#tabelaFotos').DataTable().destroy()
            $('#tabelaFotos').empty()
        }

        const columns = [
            {
                data: 'opcoes',
                title: 'Opções',
                render: function (data) {
                    return retornarBotaoOpcoes(data)
                },
            },
            {
                data: 'base64',
                title: 'Base 64',
                visible: false,
            },
        ]

        const table = $('#tabelaFotos').DataTable({
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            info: false,
            ordering: false,
            sorting: false,
            order: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '200px',
            select: {
                style: 'single',
                toggleable: false,
            },
        })

        let selectedRowIndex = 0

        function selectRow(index) {
            const row = table.row(index)
            if (row.node()) {
                table.rows().deselect()
                table.row(index).select()
                selectedRowIndex = index
            }
        }

        table.off('select')
        table.on('select', function (_e, _dt, type, indexes) {
            if (type === 'row') {
                const data = table.rows(indexes[0]).data().toArray()
                selectedRowIndex = indexes[0]
                $('#imgRepresentante').attr('src', data?.[0]?.base64 ?? '')
            }
        })

        if (data.length > 0) {
            selectRow(0)
        }
    }

    $('#tabelaFotos').on('click', '#btnExcluir', async function () {
        const tabela = $('#tabelaFotos').DataTable()
        const row = tabela.row($(this).parents('tr'))
        row.remove().draw(false)
        if (tabela.rows().count() > 0) {
            tabela.row(0).select()
        } else {
            $('#imgRepresentante').attr('src', `${BASE_URI}/dist/img/prod-1.png`)
        }
    })

    $('#modalFotos').on('shown.bs.modal', function () {
        $('#tabelaFotos').DataTable().columns.adjust()
    })

    $('#txtFotoRepresentante').on('change', function () {
        const files = event.target.files;

        if (!files.length) return;

        for (const file of files) {
            if (!file.type.startsWith('image/')) continue;

            const reader = new FileReader();

            reader.onload = function (e) {
                const base64 = e.target.result;
                $('#tabelaFotos').DataTable().row.add({ base64, opcoes: 'Opções' }).draw(false)
            };

            reader.readAsDataURL(file);
        }
        $(this).val('');
    })

    $('#btnIncluirFoto').on('click', function () {
        $('#txtFotoRepresentante').click()
    })

    $('#btnConfirmarFoto').on('click', function () {
        const fotos = $('#tabelaFotos')
            .DataTable()
            .data()
            .toArray()
            .map((item) => item.base64)
        Representante.fotos = fotos
        $('#modalFotos').modal('hide')
    })

    async function retornarFotoEmBase64(image) {
        try {
            if (!image) {
                return ''
            }

            let baseString = '';
            await new Promise(async (resolve) => {
                let reader = new FileReader();
                reader.onloadend = function () {
                    baseString = reader.result;
                    resolve()
                };
                reader.readAsDataURL(image);
            })
            return baseString
        } catch (error) {
            return ''
        }
    }

    async function buscarFotosRepresentante(codigo) {
        const response = await requisicao(
            'GET',
            `/sisplan/cadastros/v1/fotosrepresentante?`,
            `CODREP=${encodeURIComponent(codigo)}`,
            '',
            3600000,
        )
        const json = await response.json()
        if (json) {
            const { resultado, mensagem } = json
            if (mensagem?.codigo !== 200) {
                throw mensagem?.mensagem
            }

            return resultado?.bases64 || []
        }
    }

    async function validarSeClienteUtilizaReconhecimentoFacial() {
        try {
            const response = await fetch('http://127.0.0.1:3500/ping', {
                method: 'GET',
            })

            if (response?.status === 200) {
                $('#divReconhecimentoFacial').removeClass('d-none')
            }
        } catch (error) {
            $('#divReconhecimentoFacial').addClass('d-none')
        }
    }

    validarSeClienteUtilizaReconhecimentoFacial()
});


window.Representante = window.Representante || {}

Representante.fotos = null